# install.packages("ggplot2")

library(ggplot2)

# Set workspace
setwd("enter your folder here")

# Read text file
df <- read.csv(file="OM S17 dataset.csv",head=TRUE,sep=",")

# Print data frame
df

# Make plot
OMS17 <- ggplot() +
  geom_rect(aes(xmin=716.5, xmax=725, ymin=0, ymax=Inf)) +
  geom_point(data = df, aes(x = avgcmOD, y = X.OM), colour="black", size=2, shape=21, fill="violetred2") + 
  xlab(' ') +
  ylab('Organic matter content [%]') +
  geom_hline(yintercept=40,linetype="dashed",size=1) +
  geom_vline(xintercept=719.5,linetype="dotted",size=1) +
  geom_vline(xintercept=720.5,linetype="dotted",size=1) +
  xlim(714.5, 753) +
  ylim(0, 100) +
  coord_flip()

# Show plot
OMS17

# Save plot
ggsave("OMS17.pdf", plot=OMS17, height=17.5, width=10, units=c("cm"), dpi=600)